#include <stdarg.h>
#include <stdio.h>
#include <stdlib.h>
#include "myriexpress.h"
#include "mx_raw.h"


void
check_error(int cond_good, char *fmt, ...)
{
  va_list args;

  if (!(cond_good)) {
    va_start(args, fmt);
    vfprintf(stderr, fmt, args);
    va_end(args);
    exit(1);
  }
}

int
main(int argc, char *argv[])
{
  uint32_t line, cnt, i, mac0, mac1, mac2, mac3, mac4, mac5;
  uint64_t nic_id[1000];
  char string[256];
  int errno, rc;
  mx_raw_endpoint_t ep;
  FILE *file;
  
  /* open file */
  check_error(argc > 1, "MAC addresses file name missing\n");
  file = fopen(argv[1], "r");
  check_error(file != NULL, "Error opening config file %s: %d\n", 
	      argv[1], errno);
  
  /* init mx */
  mx_init();
  rc = mx_raw_open_endpoint(0, NULL, 0, &ep);
  check_error(!rc, "Error opening raw endpoint: %s\n", mx_strerror(rc));
  
  line = 0;
  cnt = 0;
  
  /* read the file */
  while (fgets(string, sizeof(string), file))
    {
      line++;
      rc = sscanf(string, "%x:%x:%x:%x:%x:%x", &mac0, &mac1, 
		  &mac2, &mac3, &mac4, &mac5);
      check_error(rc == 6, "Bad MAC address at line %d: %s\n", line, string);
      
      nic_id[cnt++] = (((uint64_t) mac0 << 40) + ((uint64_t) mac1 << 32) 
		       + (mac2 << 24) + (mac3 << 16) + (mac4 << 8) + mac5);
    }
  
  rc = mx_raw_set_route_begin(ep);
  check_error(!rc, "Error add peer init: %s\n", mx_strerror(rc));
  
  /* add the peers */
  for (i = 0; i < cnt; i++)
    {
      rc = mx_raw_set_route(ep, nic_id[i], NULL, 0, 0, 0, MX_HOST_MX);
      check_error(!rc, "Error adding peer: %s\n", mx_strerror(rc));
    }

  rc = mx_raw_set_route_end(ep);
  check_error(!rc, "Error add peer init: %s\n", mx_strerror(rc));
  return 0;
}
